<?php

namespace App\Http\Controllers;

use App\Models\Pengeluaran;
use App\Models\Rolepengeluaran;
use App\Models\Satuan;
use App\Models\Supplier;
use Illuminate\Http\Request;

class PengeluranController extends Controller
{
    public function index()
    {
        $satuan = Satuan::latest()->get();
        $supplier = Supplier::latest()->get();
        $pengeluaran = Rolepengeluaran::pencarian()->latest()->get();
        $data = [
            'title' => 'Ramizah Store | Pengeluaran',
            'page' => 'Pengeluaran',
            'menuActive' => 'pengeluran',
            'menuOpen' => 'pengeluran',
        ];
        return view('admin.pengeluaran.pengeluaran', compact('data', 'satuan', 'supplier', 'pengeluaran'))->with('no', 1);
    }

    public function pengeluaran_tambah(Request $request)
    {
        $s = Supplier::latest('id', 'ASC')->limit(1)->first();
        $isi = Rolepengeluaran::where('sts_role', 'Y')->first();
        if (!empty($s->id)) {
            if (empty($isi)) {
                $id = Rolepengeluaran::create([
                    'supplier_id' => $s->id,
                    'kd_pengeluaran' => kodepengeluaran(),
                    'total' => 0,
                    'sts_role' => 'Y',
                ])->id;

                Pengeluaran::create([
                    'rolepengeluaran_id' => $id,
                    'satuan_id' => $request->satuan,
                    'nm_barang' => $request->nama,
                    'jml' => $request->qty,
                    'harga' => $request->harga,
                ]);
            } else {
                Pengeluaran::create([
                    'rolepengeluaran_id' => $isi->id,
                    'satuan_id' => $request->satuan,
                    'nm_barang' => $request->nama,
                    'jml' => $request->qty,
                    'harga' => $request->harga,
                ]);
            }

            $data = 'sukses';
        } else {
            $data = 'gagal';
        }
        return response()->json($data);
    }

    public function data_pengeluaran()
    {
        $isi = Rolepengeluaran::where('sts_role', 'Y')->first();
        if (!empty($isi)) {
            return view('admin.pengeluaran.dt_pengeluaran', compact('isi'))->with('no', 1);
        }
    }

    public function data_total()
    {
        $d = Rolepengeluaran::where('sts_role', 'Y')->first();
        if (!empty($d)) {
            $k = Pengeluaran::where('rolepengeluaran_id', $d->id)->selectRaw('SUM(harga * jml) as jml')->groupBy('rolepengeluaran_id')->first();
            $data = [
                'total' => 'Rp. ' . number_format($k->jml, 0, ',', '.'),
                'totalasl' => $k->jml,
            ];
            return response()->json($data);
        }
    }

    public function update(Request $request)
    {
        $id = $request->id;
        $fl = $request->fl;
        $value = $request->value;

        $pengeluaran = Pengeluaran::findOrFail($id);
        if (!empty($value)) {
            $pengeluaran->update([
                $fl => $request->value,
            ]);
        }
        return response()->json();
    }

    public function hapus(Request $request)
    {
        $pg = Pengeluaran::where('id', $request->id)->first();
        $cek = Pengeluaran::where('rolepengeluaran_id', $pg->rolepengeluaran_id)->count();
        if ($cek == 1) {
            Pengeluaran::findOrFail($request->id)->delete();
            Rolepengeluaran::findOrFail($pg->rolepengeluaran_id)->delete();
        } else {
            Pengeluaran::findOrFail($request->id)->delete();
        }
        return response()->json();
    }

    public function simpan(Request $request)
    {
        $isi = Rolepengeluaran::where('sts_role', 'Y')->first();
        $isi->update([
            'supplier_id' => $request->supplier,
            'total' => $request->ttl,
            'sts_role' => 'N',
        ]);
        return response()->json();
    }

    public function destroy_all_pengeluaran(Request $request)
    {
        $ids = $request->allVals;
        foreach ($ids as  $id) {
            Rolepengeluaran::where('id', $id)->delete();
        }
        return response()->json();
    }

    public function detail_pengeluaran(Request $request)
    {
        $p = Rolepengeluaran::where('id', $request->id)->first();
        return view('admin.pengeluaran.dt_detail', compact('p'))->with('no', 1);
    }
}
